#!/usr/bin/env python3
"""
Migration script to add missing fields to chat_messages table
"""

import asyncio
import sys
import os

# Add the project root to the Python path
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from database.database import db
from sqlalchemy import text

async def migrate_chat_messages():
    """Add missing fields to chat_messages table"""
    
    async with db.get_session() as session:
        try:
            # Add to_user field
            await session.execute(text("""
                ALTER TABLE chat_messages 
                ADD COLUMN to_user BIGINT NULL,
                ADD FOREIGN KEY (to_user) REFERENCES users(user_id)
            """))
            print("✅ Added to_user field")
        except Exception as e:
            if "Duplicate column name" in str(e) or "already exists" in str(e):
                print("ℹ️  to_user field already exists")
            else:
                print(f"❌ Error adding to_user: {e}")
        
        try:
            # Add receiver_id field
            await session.execute(text("""
                ALTER TABLE chat_messages 
                ADD COLUMN receiver_id BIGINT NULL,
                ADD FOREIGN KEY (receiver_id) REFERENCES users(user_id)
            """))
            print("✅ Added receiver_id field")
        except Exception as e:
            if "Duplicate column name" in str(e) or "already exists" in str(e):
                print("ℹ️  receiver_id field already exists")
            else:
                print(f"❌ Error adding receiver_id: {e}")
        
        try:
            # Add is_read field
            await session.execute(text("""
                ALTER TABLE chat_messages 
                ADD COLUMN is_read BOOLEAN DEFAULT FALSE
            """))
            print("✅ Added is_read field")
        except Exception as e:
            if "Duplicate column name" in str(e) or "already exists" in str(e):
                print("ℹ️  is_read field already exists")
            else:
                print(f"❌ Error adding is_read: {e}")
        
        try:
            # Add is_deleted field
            await session.execute(text("""
                ALTER TABLE chat_messages 
                ADD COLUMN is_deleted BOOLEAN DEFAULT FALSE
            """))
            print("✅ Added is_deleted field")
        except Exception as e:
            if "Duplicate column name" in str(e) or "already exists" in str(e):
                print("ℹ️  is_deleted field already exists")
            else:
                print(f"❌ Error adding is_deleted: {e}")
        
        await session.commit()
        print("🎉 Migration completed successfully!")

if __name__ == "__main__":
    asyncio.run(migrate_chat_messages())
