"""
Help Handler - هندلر راهنما
راهنمای استفاده از بات
"""

from aiogram import Router, F
from aiogram.types import Message, CallbackQuery, InlineKeyboardMarkup, InlineKeyboardButton, ReplyKeyboardMarkup, KeyboardButton
import logging

router = Router()
logger = logging.getLogger(__name__)

@router.message(F.text == "❓ راهنما")
async def help_menu(message: Message):
    """نمایش منوی راهنما"""
    text = "❓ <b>راهنمای ChatDate</b>\n\n"
    text += "به راهنمای بات خوش آمدید! 🌹\n\n"
    text += "یک موضوع را انتخاب کنید:"
    
    # کیبورد کاستوم برای راهنما
    keyboard = ReplyKeyboardMarkup(
        keyboard=[
            [
                KeyboardButton(text="🚀 شروع سریع"),
                KeyboardButton(text="👤 راهنمای پروفایل")
            ],
            [
                KeyboardButton(text="🔍 راهنمای یافتن مچ"),
                KeyboardButton(text="💬 گفتگو")
            ],
            [
                KeyboardButton(text="⭐ راهنمای پریمیوم"),
                KeyboardButton(text="🔒 حریم خصوصی")
            ],
            [
                KeyboardButton(text="❓ سوالات متداول"),
                KeyboardButton(text="📞 پشتیبانی")
            ],
            [
                KeyboardButton(text="📢 معرفی به دوستان")
            ],
            [
                KeyboardButton(text="🔙 بازگشت به منو")
            ]
        ],
        resize_keyboard=True,
        one_time_keyboard=False
    )
    
    await message.answer(text, reply_markup=keyboard, parse_mode='HTML')

# Message handlers برای دکمه‌های کیبورد کاستوم
@router.message(F.text == "🚀 شروع سریع")
async def help_quick_start_message(message: Message):
    """راهنمای شروع سریع از طریق message"""
    await help_quick_start_action(message)

@router.message(F.text == "👤 راهنمای پروفایل")
async def help_profile_message(message: Message):
    """راهنمای پروفایل از طریق message"""
    await help_profile_action(message)

@router.message(F.text == "🔍 راهنمای یافتن مچ")
async def help_matching_message(message: Message):
    """راهنمای یافتن مچ از طریق message"""
    await help_matching_action(message)

@router.message(F.text == "💬 گفتگو")
async def help_chat_message(message: Message):
    """راهنمای گفتگو از طریق message"""
    await help_chat_action(message)

@router.message(F.text == "⭐ راهنمای پریمیوم")
async def help_premium_message(message: Message):
    """راهنمای پریمیوم از طریق message"""
    await help_premium_action(message)

@router.message(F.text == "🔒 حریم خصوصی")
async def help_privacy_message(message: Message):
    """راهنمای حریم خصوصی از طریق message"""
    await help_privacy_action(message)

@router.message(F.text == "❓ سوالات متداول")
async def help_faq_message(message: Message):
    """سوالات متداول از طریق message"""
    await help_faq_action(message)

@router.message(F.text == "📞 پشتیبانی")
async def help_support_message(message: Message):
    """پشتیبانی از طریق message"""
    await help_support_action(message)

@router.message(F.text == "📢 معرفی به دوستان")
async def share_bot_message(message: Message):
    """معرفی به دوستان از طریق message"""
    await share_bot_action(message)

@router.message(F.text == "🔙 بازگشت به منو")
async def back_to_main_menu_help(message: Message):
    """بازگشت به منوی اصلی"""
    from aiogram.types import ReplyKeyboardRemove
    
    await message.answer(
        "🏠 <b>بازگشت به منوی اصلی</b>\n\n"
        "✅ شما به منوی اصلی بازگشتید.\n"
        "❓ برای مشاهده راهنما دوباره، روی دکمه 'راهنما' کلیک کنید.",
        reply_markup=ReplyKeyboardRemove(),
        parse_mode='HTML'
    )

# توابع کمکی
async def help_quick_start_action(message: Message):
    """عملکرد راهنمای شروع سریع"""
    text = "🚀 <b>شروع سریع</b>\n\n"
    text += "<b>مراحل شروع:</b>\n"
    text += "1️⃣ ثبت‌نام کنید (/start)\n"
    text += "2️⃣ پروفایل خود را کامل کنید\n"
    text += "3️⃣ عکس آپلود کنید\n"
    text += "4️⃣ شروع به یافتن مچ کنید\n"
    text += "5️⃣ با مچ‌های خود گفتگو کنید\n\n"
    text += "💡 <b>نکات مهم:</b>\n"
    text += "• پروفایل کامل = مچ بیشتر\n"
    text += "• عکس‌های با کیفیت = لایک بیشتر\n"
    text += "• بیو جذاب = توجه بیشتر"
    
    await message.answer(text, parse_mode='HTML')

async def help_profile_action(message: Message):
    """عملکرد راهنمای پروفایل"""
    text = "👤 <b>راهنمای پروفایل</b>\n\n"
    text += "<b>ویرایش پروفایل:</b>\n"
    text += "• نام: حداکثر 50 کاراکتر\n"
    text += "• بیو: حداکثر 200 کاراکتر\n"
    text += "• علایق: حداکثر 10 مورد\n"
    text += "• عکس: حداکثر 5 عکس\n\n"
    text += "<b>نکات برای پروفایل بهتر:</b>\n"
    text += "✅ از عکس‌های واضح و جدید استفاده کنید\n"
    text += "✅ بیو خلاقانه و صادقانه بنویسید\n"
    text += "✅ علایق واقعی خود را ذکر کنید\n"
    text += "❌ از اطلاعات شخصی مثل شماره تلفن خودداری کنید"
    
    await message.answer(text, parse_mode='HTML')

async def help_matching_action(message: Message):
    """عملکرد راهنمای یافتن مچ"""
    text = "🔍 <b>راهنمای یافتن مچ</b>\n\n"
    text += "<b>نحوه کار:</b>\n"
    text += "1. روی 'یافتن مچ' کلیک کنید\n"
    text += "2. پروفایل‌های پیشنهادی را مشاهده کنید\n"
    text += "3. لایک یا رد کنید\n"
    text += "4. اگر طرف مقابل هم شما را لایک کند = مچ! 🎉\n\n"
    text += "<b>انواع تعامل:</b>\n"
    text += "❤️ لایک - علاقه‌مندی معمولی\n"
    text += "⭐ سوپر لایک - علاقه‌مندی ویژه (پریمیوم)\n"
    text += "👎 رد کردن - عدم علاقه\n"
    text += "🚫 گزارش - محتوای نامناسب"
    
    await message.answer(text, parse_mode='HTML')

async def help_chat_action(message: Message):
    """عملکرد راهنمای گفتگو"""
    text = "💬 <b>راهنمای گفتگو</b>\n\n"
    text += "<b>شروع گفتگو:</b>\n"
    text += "فقط با مچ‌های خود می‌توانید گفتگو کنید.\n\n"
    text += "<b>قوانین گفتگو:</b>\n"
    text += "✅ احترام متقابل\n"
    text += "✅ صداقت در گفتگو\n"
    text += "❌ ارسال محتوای نامناسب\n"
    text += "❌ درخواست اطلاعات مالی\n"
    text += "❌ آزار و اذیت\n\n"
    text += "⚠️ در صورت تخلف، حساب شما مسدود خواهد شد."
    
    await message.answer(text, parse_mode='HTML')

async def help_premium_action(message: Message):
    """عملکرد راهنمای پریمیوم"""
    text = "⭐ <b>راهنمای پریمیوم</b>\n\n"
    text += "<b>مزایای پریمیوم:</b>\n"
    text += "• 👁️ مشاهده همه لایک‌ها\n"
    text += "• ⭐ سوپر لایک نامحدود\n"
    text += "• 🚀 بوست پروفایل\n"
    text += "• 🔍 فیلترهای پیشرفته\n"
    text += "• 👻 حالت ناشناس\n"
    text += "• 📍 تغییر موقعیت\n"
    text += "• 🚫 بدون تبلیغات\n\n"
    text += "<b>نحوه خرید:</b>\n"
    text += "1. به بخش پریمیوم بروید\n"
    text += "2. پلن مورد نظر را انتخاب کنید\n"
    text += "3. پرداخت کنید\n"
    text += "4. فوراً فعال می‌شود!\n\n"
    text += "💳 برای خرید روی دکمه 'پریمیوم' در منوی اصلی کلیک کنید."
    
    await message.answer(text, parse_mode='HTML')

async def help_privacy_action(message: Message):
    """عملکرد راهنمای حریم خصوصی"""
    text = "🔒 <b>حریم خصوصی</b>\n\n"
    text += "<b>اطلاعات محفوظ شما:</b>\n"
    text += "• شماره تلفن\n"
    text += "• آدرس دقیق\n"
    text += "• اطلاعات پرداخت\n\n"
    text += "<b>اطلاعات قابل مشاهده:</b>\n"
    text += "• نام (اختیاری)\n"
    text += "• سن\n"
    text += "• جنسیت\n"
    text += "• بیو و علایق\n"
    text += "• عکس‌ها\n\n"
    text += "💡 می‌توانید هر زمان حساب خود را حذف کنید."
    
    await message.answer(text, parse_mode='HTML')

async def help_faq_action(message: Message):
    """عملکرد سوالات متداول"""
    text = "❓ <b>سوالات متداول</b>\n\n"
    text += "<b>س: چگونه عکس آپلود کنم؟</b>\n"
    text += "ج: از بخش پروفایل > آپلود عکس\n\n"
    text += "<b>س: چرا مچ پیدا نمی‌کنم؟</b>\n"
    text += "ج: پروفایل را کامل کنید و عکس آپلود کنید\n\n"
    text += "<b>س: چگونه پریمیوم بخرم؟</b>\n"
    text += "ج: از منوی اصلی > پریمیوم\n\n"
    text += "<b>س: چگونه کسی را گزارش کنم؟</b>\n"
    text += "ج: در پروفایل کاربر > دکمه گزارش\n\n"
    text += "<b>س: آیا اطلاعاتم امن است؟</b>\n"
    text += "ج: بله، ما از رمزنگاری استفاده می‌کنیم"
    
    await message.answer(text, parse_mode='HTML')

async def help_support_action(message: Message):
    """عملکرد پشتیبانی"""
    text = "📞 <b>پشتیبانی</b>\n\n"
    text += "برای ارتباط با پشتیبانی:\n\n"
    text += "📧 ایمیل: support@chatdate.com\n"
    text += "📱 تلگرام: @ChatDateSupport\n"
    text += "⏰ پاسخگویی: 9 صبح تا 9 شب\n\n"
    text += "لطفاً در پیام خود موارد زیر را ذکر کنید:\n"
    text += "• شماره کاربری\n"
    text += "• شرح مشکل\n"
    text += "• اسکرین‌شات (در صورت نیاز)\n\n"
    text += "🔗 لینک پشتیبانی: https://t.me/ChatDateSupport"
    
    await message.answer(text, parse_mode='HTML')

async def share_bot_action(message: Message):
    """عملکرد معرفی به دوستان"""
    text = "📢 <b>معرفی به دوستان</b>\n\n"
    text += "بات ChatDate را به دوستان خود معرفی کنید!\n\n"
    text += "🎁 با معرفی هر دوست:\n"
    text += "• 7 روز پریمیوم رایگان\n"
    text += "• 5 سوپر لایک رایگان\n\n"
    text += "📱 لینک اختصاصی شما:\n"
    text += f"<code>https://t.me/ChatDateBot?start=ref_{message.from_user.id}</code>\n\n"
    text += "👆 روی لینک کلیک کنید تا کپی شود\n\n"
    text += "💬 پیام پیشنهادی:\n"
    text += "\"دوست عزیز! بیا ChatDate رو امتحان کن، عالیه! 🌹\""
    
    await message.answer(text, parse_mode='HTML')

# ==================== پایان فایل ====================
# تمام callback handlerها حذف شدند - فقط کیبورد کاستوم استفاده می‌شود
