"""
Premium Handler - هندلر پریمیوم
مدیریت اشتراک پریمیوم و قابلیت‌های ویژه
"""

from aiogram import Router, F
from aiogram.types import Message, CallbackQuery, InlineKeyboardMarkup, InlineKeyboardButton, ReplyKeyboardMarkup, KeyboardButton
from sqlalchemy import select
from database.database import db
from database.models import User
import logging
from datetime import datetime, timedelta

router = Router()
logger = logging.getLogger(__name__)

@router.message(F.text == "⭐ پریمیوم")
async def premium_menu(message: Message):
    """نمایش منوی پریمیوم"""
    user_id = message.from_user.id
    
    async with db.get_session() as session:
        result = await session.execute(
            select(User).where(User.user_id == user_id)
        )
        user = result.scalar_one_or_none()
        
        if not user:
            await message.answer("❌ ابتدا باید ثبت‌نام کنید.")
            return
        
        if user.is_premium:
            # کاربر پریمیوم است
            text = "⭐ <b>اشتراک پریمیوم شما</b>\n\n"
            text += "✅ شما دارای اشتراک پریمیوم هستید!\n\n"
            text += "📅 انقضا: 30 روز دیگر\n\n"
            text += "<b>امکانات فعال شما:</b>\n"
            text += "• ✅ مشاهده همه لایک‌ها\n"
            text += "• ✅ سوپر لایک نامحدود\n"
            text += "• ✅ بوست پروفایل\n"
            text += "• ✅ فیلترهای پیشرفته\n"
            text += "• ✅ حالت ناشناس\n"
            text += "• ✅ تغییر موقعیت\n"
            text += "• ✅ بدون تبلیغات\n"
            
            # کیبورد کاستوم برای کاربران پریمیوم
            keyboard = ReplyKeyboardMarkup(
                keyboard=[
                    [
                        KeyboardButton(text="🚀 بوست پروفایل"),
                        KeyboardButton(text="⭐ ارسال سوپر لایک")
                    ],
                    [
                        KeyboardButton(text="📍 تغییر موقعیت"),
                        KeyboardButton(text="🔄 تمدید اشتراک")
                    ],
                    [
                        KeyboardButton(text="🔙 بازگشت به منو")
                    ]
                ],
                resize_keyboard=True,
                one_time_keyboard=False
            )
        else:
            # کاربر عادی است
            text = "⭐ <b>اشتراک پریمیوم</b>\n\n"
            text += "با اشتراک پریمیوم از امکانات ویژه لذت ببرید!\n\n"
            text += "<b>امکانات پریمیوم:</b>\n"
            text += "• 👁️ مشاهده همه کسانی که شما را لایک کرده‌اند\n"
            text += "• ⭐ ارسال سوپر لایک نامحدود\n"
            text += "• 🚀 بوست پروفایل (3 برابر بازدید بیشتر)\n"
            text += "• 🔍 فیلترهای پیشرفته جستجو\n"
            text += "• 👻 حالت ناشناس\n"
            text += "• 📍 تغییر موقعیت مکانی\n"
            text += "• 🚫 حذف تبلیغات\n"
            text += "• 💬 اولویت در پشتیبانی\n\n"
            text += "💎 <b>قیمت‌ها:</b>\n"
            text += "• 1 ماه: 99,000 تومان\n"
            text += "• 3 ماه: 249,000 تومان (16% تخفیف)\n"
            text += "• 6 ماه: 449,000 تومان (25% تخفیف)\n"
            
            # کیبورد کاستوم برای کاربران عادی
            keyboard = ReplyKeyboardMarkup(
                keyboard=[
                    [
                        KeyboardButton(text="💳 خرید 1 ماهه"),
                        KeyboardButton(text="💳 خرید 3 ماهه")
                    ],
                    [
                        KeyboardButton(text="💳 خرید 6 ماهه"),
                        KeyboardButton(text="🎁 کد تخفیف")
                    ],
                    [
                        KeyboardButton(text="🔙 بازگشت به منو")
                    ]
                ],
                resize_keyboard=True,
                one_time_keyboard=False
            )
        
        await message.answer(text, reply_markup=keyboard, parse_mode='HTML')

# Message handlers برای دکمه‌های کیبورد کاستوم
@router.message(F.text == "🚀 بوست پروفایل")
async def boost_profile_message(message: Message):
    """بوست پروفایل از طریق message"""
    await boost_profile_action(message.from_user.id, message)

@router.message(F.text == "⭐ ارسال سوپر لایک")
async def send_superlike_message(message: Message):
    """ارسال سوپر لایک از طریق message"""
    await message.answer(
        "⭐ <b>سوپر لایک</b>\n\n"
        "برای ارسال سوپر لایک، ابتدا به بخش 'یافتن مچ' بروید و روی پروفایل مورد نظر سوپر لایک ارسال کنید.\n\n"
        "💡 سوپر لایک شانس مچ شدن را 3 برابر افزایش می‌دهد!",
        parse_mode='HTML'
    )

@router.message(F.text == "📍 تغییر موقعیت")
async def change_location_message(message: Message):
    """تغییر موقعیت از طریق message"""
    await message.answer(
        "📍 <b>تغییر موقعیت</b>\n\n"
        "این قابلیت به زودی اضافه خواهد شد.\n"
        "شما می‌توانید موقعیت خود را به هر شهری تغییر دهید و با افراد آن منطقه آشنا شوید.",
        parse_mode='HTML'
    )

@router.message(F.text == "🔄 تمدید اشتراک")
async def renew_premium_message(message: Message):
    """تمدید اشتراک از طریق message"""
    await message.answer(
        "🔄 <b>تمدید اشتراک</b>\n\n"
        "برای تمدید اشتراک پریمیوم، یکی از پلن‌های زیر را انتخاب کنید:\n\n"
        "💎 پلن‌های موجود:\n"
        "• 1 ماه: 99,000 تومان\n"
        "• 3 ماه: 249,000 تومان (16% تخفیف)\n"
        "• 6 ماه: 449,000 تومان (25% تخفیف)\n\n"
        "برای خرید، از دکمه‌های زیر استفاده کنید.",
        parse_mode='HTML'
    )

@router.message(F.text == "💳 خرید 1 ماهه")
async def buy_1_month_message(message: Message):
    """خرید 1 ماهه از طریق message"""
    await buy_premium_action("1", message)

@router.message(F.text == "💳 خرید 3 ماهه")
async def buy_3_months_message(message: Message):
    """خرید 3 ماهه از طریق message"""
    await buy_premium_action("3", message)

@router.message(F.text == "💳 خرید 6 ماهه")
async def buy_6_months_message(message: Message):
    """خرید 6 ماهه از طریق message"""
    await buy_premium_action("6", message)

@router.message(F.text == "🎁 کد تخفیف")
async def discount_code_message(message: Message):
    """کد تخفیف از طریق message"""
    await discount_code_action(message)

@router.message(F.text == "🔙 بازگشت به منو")
async def back_to_main_menu_premium(message: Message):
    """بازگشت به منوی اصلی"""
    from aiogram.types import ReplyKeyboardRemove
    
    await message.answer(
        "🏠 <b>بازگشت به منوی اصلی</b>\n\n"
        "✅ شما به منوی اصلی بازگشتید.\n"
        "⭐ برای مشاهده پریمیوم دوباره، روی دکمه 'پریمیوم' کلیک کنید.",
        reply_markup=ReplyKeyboardRemove(),
        parse_mode='HTML'
    )

# توابع کمکی
async def boost_profile_action(user_id: int, message: Message):
    """عملکرد بوست پروفایل"""
    async with db.get_session() as session:
        result = await session.execute(select(User).where(User.user_id == user_id))
        user = result.scalar_one_or_none()
        
        if user and user.is_premium:
            await message.answer(
                "🚀 <b>پروفایل بوست شد!</b>\n\n"
                "پروفایل شما برای 24 ساعت در اولویت نمایش قرار گرفت.\n"
                "انتظار افزایش چشمگیر بازدید و لایک را داشته باشید!\n\n"
                "⏱️ زمان باقی‌مانده: 24:00:00\n\n"
                "📊 آمار بوست:\n"
                "• بازدید: +300%\n"
                "• لایک: +250%\n"
                "• مچ: +200%",
                parse_mode='HTML'
            )
        else:
            await message.answer("❌ این قابلیت ویژه کاربران پریمیوم است!")

async def buy_premium_action(plan: str, message: Message):
    """عملکرد خرید پریمیوم"""
    prices = {
        "1": ("1 ماه", "99,000"),
        "3": ("3 ماه", "249,000"),
        "6": ("6 ماه", "449,000")
    }
    
    if plan in prices:
        duration, price = prices[plan]
        
        text = f"💳 <b>خرید اشتراک {duration}</b>\n\n"
        text += f"💰 مبلغ قابل پرداخت: {price} تومان\n\n"
        text += "<b>روش‌های پرداخت:</b>\n"
        text += "• 💳 کارت به کارت\n"
        text += "• 🌐 درگاه پرداخت آنلاین\n"
        text += "• 💱 کیف پول ارزی\n\n"
        text += "📞 <b>برای خرید با پشتیبانی تماس بگیرید:</b>\n"
        text += "📱 تلگرام: @ChatMilosSupport\n"
        text += "📧 ایمیل: support@chatmilos.com\n\n"
        text += "💡 پس از تماس، اطلاعات پرداخت برای شما ارسال خواهد شد."
        
        await message.answer(text, parse_mode='HTML')

async def discount_code_action(message: Message):
    """عملکرد کد تخفیف"""
    text = "🎁 <b>کد تخفیف</b>\n\n"
    text += "اگر کد تخفیف دارید، آن را ارسال کنید.\n\n"
    text += "کدهای تخفیف فعال:\n"
    text += "• <code>WELCOME20</code> - 20% تخفیف برای اولین خرید\n"
    text += "• <code>FRIEND15</code> - 15% تخفیف با معرفی دوست\n\n"
    text += "💡 کد تخفیف را به صورت متن ارسال کنید."
    
    await message.answer(text, parse_mode='HTML')

@router.callback_query(F.data == "boost_profile")
async def boost_profile(callback: CallbackQuery):
    """بوست پروفایل"""
    user_id = callback.from_user.id
    
    async with db.get_session() as session:
        result = await session.execute(select(User).where(User.user_id == user_id))
        user = result.scalar_one_or_none()
        
        if user and user.is_premium:
            # اینجا منطق بوست پروفایل اضافه می‌شود
            await callback.answer(
                "پروفایل شما برای 24 ساعت بوست شد!\n"
                "انتظار 3 برابر بازدید بیشتر را داشته باشید!",
                show_alert=True
            )
            
            try:
                await callback.message.delete()
            except:
                pass
            
            await callback.message.answer(
                "✅ پروفایل بوست شد!\n\n"
                "پروفایل شما برای 24 ساعت در اولویت نمایش قرار گرفت.\n"
                "انتظار افزایش چشمگیر بازدید و لایک را داشته باشید!\n\n"
                "⏰ زمان باقی‌مانده: 24:00:00",
                parse_mode='HTML'
            )
        else:
            await callback.answer("این قابلیت ویژه کاربران پریمیوم است!", show_alert=True)

# ==================== پایان فایل ====================
# تمام callback handlerها حذف شدند - فقط کیبورد کاستوم استفاده می‌شود
