#!/usr/bin/env python3
"""
Recreate chat_messages table with correct structure
"""

import asyncio
import sys
import os

# Add the project root to the Python path
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from database.database import db
from sqlalchemy import text

async def recreate_chat_table():
    """Recreate chat_messages table with correct structure"""
    
    async with db.get_session() as session:
        try:
            # Drop existing table
            await session.execute(text("DROP TABLE IF EXISTS chat_messages"))
            print("✅ Dropped existing chat_messages table")
            
            # Create new table with simple structure
            await session.execute(text("""
                CREATE TABLE chat_messages (
                    id BIGINT AUTO_INCREMENT PRIMARY KEY,
                    match_id BIGINT NOT NULL,
                    sender_id BIGINT NOT NULL,
                    message_type VARCHAR(20),
                    content TEXT,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (match_id) REFERENCES matches(id),
                    FOREIGN KEY (sender_id) REFERENCES users(user_id)
                )
            """))
            print("✅ Created new chat_messages table")
            
            await session.commit()
            print("🎉 Table recreation completed successfully!")
            
        except Exception as e:
            print(f"❌ Error recreating table: {e}")
            await session.rollback()

if __name__ == "__main__":
    asyncio.run(recreate_chat_table())
