#!/usr/bin/env python3
"""Chat Room Creator - ایجاد خودکار گروه با Pyrogram"""

import logging
import asyncio
from typing import Optional, Tuple
from pyrogram import Client
from pyrogram.types import Chat
from pyrogram.errors import FloodWait
import hashlib
from datetime import datetime

logger = logging.getLogger(__name__)

# تنظیمات Pyrogram
import os
from dotenv import load_dotenv

load_dotenv()

API_ID = int(os.getenv("TELEGRAM_API_ID", "707515"))
API_HASH = os.getenv("TELEGRAM_API_HASH", "c5b86e926d51fe0165d5304fb6772f9c")
PHONE_NUMBER = os.getenv("TELEGRAM_PHONE", "+905453939096")
SESSION_NAME = "chatmilos_userbot"

# ایجاد کلاینت Pyrogram
userbot = Client(
    SESSION_NAME,
    api_id=API_ID,
    api_hash=API_HASH,
    phone_number=PHONE_NUMBER
)

async def create_private_group(user1_id: int, user2_id: int, bot_username: str = "ChatMilosBot") -> Tuple[bool, str, Optional[int]]:
    """
    ایجاد گروه خصوصی برای دو کاربر
    
    Returns:
        (success, message, chat_id)
    """
    try:
        async with userbot:
            # ایجاد نام یکتا برای گروه
            timestamp = datetime.now().strftime('%Y%m%d%H%M%S')
            room_id = hashlib.md5(f"{user1_id}_{user2_id}_{timestamp}".encode()).hexdigest()[:8]
            group_title = f"💬 اتاق گفتگو #{room_id}"
            
            # ایجاد گروه جدید
            try:
                # ایجاد supergroup
                chat = await userbot.create_supergroup(
                    title=group_title,
                    description=f"اتاق گفتگو خصوصی برای دو کاربر"
                )
                
                chat_id = chat.id
                logger.info(f"Created group {group_title} with ID {chat_id}")
                
                try:
                    # اضافه کردن بات
                    await userbot.add_chat_members(chat_id, bot_username)
                    
                    # ادمین کردن بات
                    from pyrogram.types import ChatPrivileges
                    
                    await userbot.promote_chat_member(
                        chat_id=chat_id,
                        user_id=bot_username,
                        privileges=ChatPrivileges(
                            can_manage_chat=True,
                            can_delete_messages=True,
                            can_manage_video_chats=False,
                            can_restrict_members=True,
                            can_promote_members=False,
                            can_change_info=True,
                            can_invite_users=True,
                            can_post_messages=True,
                            can_edit_messages=True,
                            can_pin_messages=True,
                            can_manage_topics=False
                        )
                    )
                    logger.info(f"Bot added and promoted in group {chat_id}")
                    
                except Exception as e:
                    logger.error(f"Error adding/promoting bot: {e}")
                
                # دعوت کاربر اول
                try:
                    await userbot.add_chat_members(chat_id, user1_id)
                    logger.info(f"User {user1_id} added to group")
                except Exception as e:
                    logger.warning(f"Could not add user {user1_id}: {e}")
                    # ایجاد لینک دعوت برای کاربر اول
                    invite_link_1 = await userbot.create_chat_invite_link(chat_id)
                
                # دعوت کاربر دوم
                try:
                    await userbot.add_chat_members(chat_id, user2_id)
                    logger.info(f"User {user2_id} added to group")
                except Exception as e:
                    logger.warning(f"Could not add user {user2_id}: {e}")
                    # ایجاد لینک دعوت برای کاربر دوم
                    invite_link_2 = await userbot.create_chat_invite_link(chat_id)
                
                # خروج userbot از گروه (اختیاری)
                # await userbot.leave_chat(chat_id)
                
                return True, f"گروه {group_title} با موفقیت ایجاد شد", chat_id
                
            except FloodWait as e:
                logger.error(f"FloodWait: Need to wait {e.value} seconds")
                return False, f"محدودیت تلگرام: لطفاً {e.value} ثانیه صبر کنید", None
                
            except Exception as e:
                logger.error(f"Error creating group: {e}")
                return False, f"خطا در ایجاد گروه: {str(e)}", None
                
    except Exception as e:
        logger.error(f"Userbot connection error: {e}")
        return False, f"خطا در اتصال: {str(e)}", None

async def delete_chat_group(chat_id: int) -> bool:
    """حذف گروه بعد از اتمام گفتگو"""
    try:
        async with userbot:
            await userbot.delete_supergroup(chat_id)
            logger.info(f"Deleted group {chat_id}")
            return True
    except Exception as e:
        logger.error(f"Error deleting group {chat_id}: {e}")
        return False

# تابع کمکی برای اولین اجرا و دریافت کد
async def setup_userbot():
    """راه‌اندازی اولیه userbot"""
    await userbot.start()
    print("Userbot started successfully!")
    await userbot.stop()

if __name__ == "__main__":
    # برای اولین بار اجرا کنید تا کد تأیید را وارد کنید
    asyncio.run(setup_userbot())
