#!/usr/bin/env python3
"""Simplified database models for ChatMilos Bot (No Relationships)"""

from sqlalchemy import Column, BigInteger, String, Text, Boolean, TIMESTAMP, Enum, Integer, Index, UniqueConstraint
from sqlalchemy.sql import func
from database.models import Base

class Swipe(Base):
    __tablename__ = 'swipes'
    __table_args__ = {'extend_existing': True}
    
    id = Column(BigInteger, primary_key=True, autoincrement=True)
    from_user = Column(BigInteger, nullable=False)
    to_user = Column(BigInteger, nullable=False)
    action = Column(Integer, nullable=False)  # 0=pass, 1=like, 2=super_like
    created_at = Column(TIMESTAMP, default=func.now())

class ChatMessage(Base):
    __tablename__ = 'chat_messages'
    __table_args__ = {'extend_existing': True}
    
    id = Column(BigInteger, primary_key=True, autoincrement=True)
    match_id = Column(BigInteger, nullable=False)  # ID مچ
    sender_id = Column(BigInteger, nullable=False)  # فرستنده
    content = Column(Text, nullable=True)           # متن پیام
    message_type = Column(String(20), default='text')  # text, photo, voice, sticker, document
    created_at = Column(TIMESTAMP, default=func.now())

class Notification(Base):
    __tablename__ = 'notifications'
    __table_args__ = {'extend_existing': True}
    
    id = Column(BigInteger, primary_key=True, autoincrement=True)
    user_id = Column(BigInteger, nullable=False)
    type = Column(Enum('match', 'like', 'message', 'profile_view', 'premium_expiry'), nullable=False)
    title = Column(String(255), nullable=False)
    message = Column(Text, nullable=False)
    related_user_id = Column(BigInteger, nullable=True)
    related_match_id = Column(BigInteger, nullable=True)
    is_read = Column(Boolean, default=False)
    created_at = Column(TIMESTAMP, default=func.now())

class ProfileView(Base):
    __tablename__ = 'profile_views'
    __table_args__ = {'extend_existing': True}
    
    id = Column(BigInteger, primary_key=True, autoincrement=True)
    viewer_id = Column(BigInteger, nullable=False)
    viewed_user_id = Column(BigInteger, nullable=False)
    created_at = Column(TIMESTAMP, default=func.now())
