#!/usr/bin/env python3
"""
Fix user with wrong name
"""

import mysql.connector
import os
from dotenv import load_dotenv

load_dotenv()

def fix_user_name():
    """Fix user with wrong name"""
    
    try:
        # Database connection
        host = os.getenv('DB_HOST', 'localhost')
        port = int(os.getenv('DB_PORT', 3306))
        user = os.getenv('DB_USER', 'chatmilos_db')
        password = os.getenv('DB_PASSWORD', '')
        database = os.getenv('DB_NAME', 'chatmilos_db')
        
        print(f"🔗 Connecting to: {user}@{host}:{port}/{database}")
        
        conn = mysql.connector.connect(
            host=host,
            port=port,
            user=user,
            password=password,
            database=database
        )
        cursor = conn.cursor()
        
        # Find user with wrong name (search for patterns)
        cursor.execute("SELECT user_id, username, first_name FROM users WHERE first_name LIKE %s OR first_name LIKE %s", ("%گفتگو%", "%💬%"))
        wrong_users = cursor.fetchall()
        
        if wrong_users:
            for user_id, username, first_name in wrong_users:
                print(f"🔍 Found user with wrong name: '{first_name}' (ID: {user_id})")
                
                # Update the name
                new_name = f"کاربر_{user_id}"
                cursor.execute("UPDATE users SET first_name = %s WHERE user_id = %s", (new_name, user_id))
                conn.commit()
                
                print(f"✅ Updated user name to: {new_name}")
        else:
            print("✅ No user with wrong name found")
        
        # Also check for specific user ID 436959656
        cursor.execute("SELECT user_id, username, first_name FROM users WHERE user_id = %s", (436959656,))
        specific_user = cursor.fetchone()
        
        if specific_user:
            user_id, username, first_name = specific_user
            print(f"🔍 User 436959656: username='{username}', first_name='{first_name}'")
            
            # Fix username if it contains wrong text
            if username and ("گفتگو" in username or "💬" in username):
                cursor.execute("UPDATE users SET username = NULL WHERE user_id = %s", (user_id,))
                conn.commit()
                print(f"✅ Cleared wrong username for user {user_id}")
            
            # Fix first_name if needed
            if first_name and ("گفتگو" in first_name or "💬" in first_name):
                new_name = f"کاربر_{user_id}"
                cursor.execute("UPDATE users SET first_name = %s WHERE user_id = %s", (new_name, user_id))
                conn.commit()
                print(f"✅ Fixed user {user_id} first_name to: {new_name}")
        
        # Show all users after fix
        cursor.execute("SELECT user_id, username, first_name FROM users")
        users = cursor.fetchall()
        
        print(f"\n👥 All users after fix:")
        for user_id, username, first_name in users:
            name = username or first_name or "کاربر"
            print(f"   - {name} (ID: {user_id})")
        
        cursor.close()
        conn.close()
        
    except Exception as e:
        print(f"❌ Error: {e}")

if __name__ == "__main__":
    fix_user_name()
