# Language codes mapping - Ordered by priority (3 per row)
LANGUAGE_CODES = {
    'en': 'English 🇺🇸',
    'fa': 'فارسی 🇮🇷',
    'tr': 'Türkçe 🇹🇷',
    'ru': 'Русский 🇷🇺',
    'ar': 'العربية 🇸🇦',
    'fr': 'Français 🇫🇷',
    'es': 'Español 🇪🇸',
    'uk': 'Українська 🇺🇦',
    'pt': 'Português 🇵🇹',
    'it': 'Italiano 🇮🇹',
    'de': 'Deutsch 🇩🇪',
    'pl': 'Polski 🇵🇱',
    'hi': 'हिन्दी 🇮🇳',
    'id': 'Indonesia 🇮🇩',
    'kk': 'Қазақша 🇰🇿'
}

translations = {
    'fa': {  # Persian/Farsi
        'welcome': 'به Sarium خوش آمدید! 👋\nبرای آشنایی ناشناس و امن',
        'choose_language': 'زبان خود را انتخاب کنید:',
        'setup_profile': 'بیایید پروفایل شما را تنظیم کنیم:\n\n1️⃣ جنسیت شما؟\n2️⃣ دنبال چه کسی هستید؟\n3️⃣ شهر/کشور؟\n4️⃣ موقعیت تقریبی؟',
        'gender_male': '👨 مرد',
        'gender_female': '👩 زن',
        'gender_other': '🏳️‍🌈 غیره',
        'looking_for_male': 'دنبال مرد',
        'looking_for_female': 'دنبال زن',
        'looking_for_any': 'فرقی نمیکند',
        'share_location': '📍 ارسال موقعیت',
        'skip_location': '⏭️ رد کردن',
        'profile_complete': 'پروفایل شما آماده است! ✅\n\n/find برای یافتن اولین مچ',
        'searching_match': '🔍 در حال جستجو برای مچ مناسب...',
        'match_found': '🎉 مچ پیدا شد!\n\nآیا می‌خواهید شروع به گفتگو کنید؟',
        'start_chat': '💬 شروع گفتگو',
        'next_match': '⏭️ مچ بعدی',
        'change_filters': '⚙️ تغییر فیلترها',
        'chat_started': '💬 گفتگو شروع شد!\n\nبرای پایان: /stop\nبرای گزارش: /report',
        'chat_ended': '👋 گفتگو پایان یافت.\n\n/find برای مچ جدید',
        'report_user': '🚨 گزارش کاربر',
        'block_user': '🚫 مسدود کردن',
        'end_chat': '❌ پایان گفتگو',
        'self_destruct': '💣 خودتخریب',
        'icebreaker': '🧊 یخ‌شکن',
        'profile_menu': '👤 پروفایل من',
        'edit_profile': '✏️ ویرایش پروفایل',
        'premium': '⭐ پریمیوم',
        'help': '❓ راهنما',
        'safety_warning': '⚠️ هرگز اطلاعات شخصی خود را ارسال نکنید!\n\nبرای امنیت بیشتر از خودتخریب استفاده کنید.',
        'report_reasons': {
            'spam': '📧 اسپم',
            'abuse': '😡 بی‌ادبی',
            'nsfw': '🔞 محتوای نامناسب',
            'other': '❓ سایر'
        },
        # Premium features
        'premium_menu': '⭐ منوی پریمیوم\n\nویژگی‌های انحصاری را باز کنید!',
        'premium_active': '✅ پریمیوم شما فعال است\n{days} روز باقی‌مانده',
        'extend_premium': '🔄 تمدید پریمیوم',
        'premium_features': '✨ ویژگی‌های پریمیوم',
        'premium_features_list': '⭐ ویژگی‌های پریمیوم:\n\n• 5 سوپرلایک در روز\n• بوست پروفایل 24 ساعته\n• فیلترهای پیشرفته\n• دیدن کسانی که شما را لایک کردند\n• سوایپ نامحدود\n• تغییر موقعیت\n• حالت نامرئی\n• تیک خوانده شدن',
        'payment_instructions': '💳 پرداخت برای {plan}\nمبلغ: ${price}',
        'confirm_payment': '✅ تایید پرداخت',
        'premium_activated': '🎉 پریمیوم فعال شد!\n{days} روز اعتبار\nتا تاریخ: {until}',
        'premium_success': 'پریمیوم با موفقیت فعال شد!',
        'premium_required': '⭐ این ویژگی نیاز به پریمیوم دارد',
        'super_likes_limit': '❌ محدودیت سوپرلایک روزانه',
        'super_like_sent': '💖 سوپرلایک ارسال شد!',
        'boost_active': '🚀 بوست فعال است ({hours} ساعت باقی‌مانده)',
        'boost_activated': '🚀 پروفایل شما برای {hours} ساعت بوست شد!',
        'invisible_mode': '👻 حالت نامرئی: {status}',
        'on': 'روشن',
        'off': 'خاموش',
        'who_liked_you': '💕 کسانی که شما را لایک کردند:',
        'no_likes': '💔 هنوز لایکی ندارید',
        'view_profiles': '👀 مشاهده پروفایل‌ها',
        'back': '🔙 بازگشت',
        'cancel': '❌ لغو',
        'error': '❌ خطا رخ داد',
        
        # Profile & Settings
        'profile': '👤 پروفایل',
        'settings': '⚙️ تنظیمات',
        'edit_profile': '✏️ ویرایش پروفایل',
        'search_settings': '⚙️ تنظیمات جستجو',
        'view_photos': '👁️ مشاهده عکس‌ها',
        'upload_photo': '📸 آپلود عکس',
        'back_to_menu': '🔙 بازگشت به منو',
        'back_to_profile': '🔙 بازگشت به پروفایل',
        'edit_name': '👤 ویرایش نام',
        'edit_age': '🎂 ویرایش سن',
        'edit_country': '🌍 ویرایش کشور',
        'edit_city': '🏙️ ویرایش شهر',
        'edit_bio': '✏️ ویرایش بیو',
        'edit_interests': '🎯 ویرایش علایق',
        'edit_gender': '⚧️ ویرایش جنسیت',
        'language': '🌍 زبان',
        'change_language': '🌍 تغییر زبان',
        'invisible_mode': '👻 حالت ناشناس',
        'privacy': '🔒 حریم خصوصی',
        'delete_account': '🗑️ حذف حساب',
        'my_stats': '📊 آمار من',
        'looking_for': '💕 دنبال چه کسی هستم',
        'age_range': '🎂 بازه سنی',
        'search_radius': '📍 شعاع جستجو'
    },
    'en': {  # English
        'welcome': 'Welcome to Sarium! 👋\nFor anonymous and safe connections',
        'choose_language': 'Choose your language:',
        'setup_profile': 'Let\'s set up your profile:\n\n1️⃣ Your gender?\n2️⃣ Who are you looking for?\n3️⃣ City/Country?\n4️⃣ Approximate location?',
        'gender_male': '👨 Male',
        'gender_female': '👩 Female',
        'gender_other': '🏳️‍🌈 Other',
        'looking_for_male': 'Looking for Male',
        'looking_for_female': 'Looking for Female',
        'looking_for_any': 'Any',
        'share_location': '📍 Share Location',
        'skip_location': '⏭️ Skip',
        'profile_complete': 'Your profile is ready! ✅\n\n/find to get your first match',
        'searching_match': '🔍 Searching for a suitable match...',
        'match_found': '🎉 Match found!\n\nWould you like to start chatting?',
        'start_chat': '💬 Start Chat',
        'next_match': '⏭️ Next Match',
        'change_filters': '⚙️ Change Filters',
        'chat_started': '💬 Chat started!\n\nTo end: /stop\nTo report: /report',
        'chat_ended': '👋 Chat ended.\n\n/find for a new match',
        'report_user': '🚨 Report User',
        'block_user': '🚫 Block User',
        'end_chat': '❌ End Chat',
        'self_destruct': '💣 Self Destruct',
        'icebreaker': '🧊 Icebreaker',
        'profile_menu': '👤 My Profile',
        'edit_profile': '✏️ Edit Profile',
        'premium': '⭐ Premium',
        'help': '❓ Help',
        'safety_warning': '⚠️ Never share your personal information!\n\nUse self-destruct for extra security.',
        'report_reasons': {
            'spam': '📧 Spam',
            'abuse': '😡 Abusive',
            'nsfw': '🔞 Inappropriate content',
            'other': '❓ Other'
        },
        # Premium features
        'premium_menu': '⭐ Premium Menu\n\nUnlock exclusive features!',
        'premium_active': '✅ Your premium is active\n{days} days remaining',
        'extend_premium': '🔄 Extend Premium',
        'premium_features': '✨ Premium Features',
        'premium_features_list': '⭐ Premium Features:\n\n• 5 Super Likes per day\n• 24-hour profile boost\n• Advanced filters\n• See who liked you\n• Unlimited swipes\n• Change location\n• Invisible mode\n• Read receipts',
        'payment_instructions': '💳 Payment for {plan}\nAmount: ${price}',
        'confirm_payment': '✅ Confirm Payment',
        'premium_activated': '🎉 Premium activated!\n{days} days validity\nUntil: {until}',
        'premium_success': 'Premium successfully activated!',
        'premium_required': '⭐ This feature requires premium',
        'super_likes_limit': '❌ Daily super like limit reached',
        'super_like_sent': '💖 Super Like sent!',
        'boost_active': '🚀 Boost is active ({hours} hours remaining)',
        'boost_activated': '🚀 Your profile is boosted for {hours} hours!',
        'invisible_mode': '👻 Invisible mode: {status}',
        'on': 'On',
        'off': 'Off',
        'who_liked_you': '💕 People who liked you:',
        'no_likes': '💔 No likes yet',
        'view_profiles': '👀 View Profiles',
        'back': '🔙 Back',
        'cancel': '❌ Cancel',
        'error': '❌ An error occurred',
        
        # Profile & Settings
        'profile': '👤 Profile',
        'settings': '⚙️ Settings',
        'edit_profile': '✏️ Edit Profile',
        'search_settings': '⚙️ Search Settings',
        'view_photos': '👁️ View Photos',
        'upload_photo': '📸 Upload Photo',
        'back_to_menu': '🔙 Back to Menu',
        'back_to_profile': '🔙 Back to Profile',
        'edit_name': '👤 Edit Name',
        'edit_age': '🎂 Edit Age',
        'edit_country': '🌍 Edit Country',
        'edit_city': '🏙️ Edit City',
        'edit_bio': '✏️ Edit Bio',
        'edit_interests': '🎯 Edit Interests',
        'edit_gender': '⚧️ Edit Gender',
        'language': '🌍 Language',
        'change_language': '🌍 Change Language',
        'invisible_mode': '👻 Invisible Mode',
        'privacy': '🔒 Privacy',
        'delete_account': '🗑️ Delete Account',
        'my_stats': '📊 My Stats',
        'looking_for': '💕 Looking For',
        'age_range': '🎂 Age Range',
        'search_radius': '📍 Search Radius'
    },
    'tr': {  # Turkish
        'welcome': 'Sarium\'a hoş geldiniz! 👋\nAnonim ve güvenli bağlantılar için',
        'choose_language': 'Dilinizi seçin:',
        'setup_profile': 'Profilinizi ayarlayalım:\n\n1️⃣ Cinsiyetiniz?\n2️⃣ Kimi arıyorsunuz?\n3️⃣ Şehir/Ülke?\n4️⃣ Yaklaşık konum?',
        'gender_male': '👨 Erkek',
        'gender_female': '👩 Kadın',
        'gender_other': '🏳️‍🌈 Diğer',
        'looking_for_male': 'Erkek Arıyor',
        'looking_for_female': 'Kadın Arıyor',
        'looking_for_any': 'Farketmez',
        'share_location': '📍 Konum Paylaş',
        'skip_location': '⏭️ Atla',
        'profile_complete': 'Profiliniz hazır! ✅\n\n/find ile ilk eşleşmenizi alın',
        'searching_match': '🔍 Uygun eşleşme aranıyor...',
        'match_found': '🎉 Eşleşme bulundu!\n\nSohbet etmeye başlamak ister misiniz?',
        'start_chat': '💬 Sohbet Başlat',
        'next_match': '⏭️ Sonraki Eşleşme',
        'change_filters': '⚙️ Filtreleri Değiştir',
        'chat_started': '💬 Sohbet başladı!\n\nBitirmek için: /stop\nŞikayet için: /report',
        'chat_ended': '👋 Sohbet bitti.\n\n/find ile yeni eşleşme',
        'report_user': '🚨 Kullanıcıyı Şikayet Et',
        'block_user': '🚫 Kullanıcıyı Engelle',
        'end_chat': '❌ Sohbeti Bitir',
        'self_destruct': '💣 Kendini İmha Et',
        'icebreaker': '🧊 Buzları Kır',
        'profile_menu': '👤 Profilim',
        'edit_profile': '✏️ Profili Düzenle',
        'premium': '⭐ Premium',
        'help': '❓ Yardım',
        'safety_warning': '⚠️ Asla kişisel bilgilerinizi paylaşmayın!\n\nEkstra güvenlik için kendini imha et özelliğini kullanın.',
        'report_reasons': {
            'spam': '📧 Spam',
            'abuse': '😡 Kötü Davranış',
            'nsfw': '🔞 Uygunsuz İçerik',
            'other': '❓ Diğer'
        },
        
        # Profile & Settings
        'profile': '👤 Profil',
        'settings': '⚙️ Ayarlar',
        'edit_profile': '✏️ Profil Düzenle',
        'search_settings': '⚙️ Arama Ayarları',
        'view_photos': '👁️ Fotoğrafları Görüntüle',
        'upload_photo': '📸 Fotoğraf Yükle',
        'back_to_menu': '🔙 Menüye Dön',
        'back_to_profile': '🔙 Profile Dön',
        'edit_name': '👤 İsim Düzenle',
        'edit_age': '🎂 Yaş Düzenle',
        'edit_country': '🌍 Ülke Düzenle',
        'edit_city': '🏙️ Şehir Düzenle',
        'edit_bio': '✏️ Biyografi Düzenle',
        'edit_interests': '🎯 İlgi Alanları Düzenle',
        'edit_gender': '⚧️ Cinsiyet Düzenle',
        'language': '🌍 Dil',
        'change_language': '🌍 Dil Değiştir',
        'invisible_mode': '👻 Görünmez Mod',
        'privacy': '🔒 Gizlilik',
        'delete_account': '🗑️ Hesabı Sil',
        'my_stats': '📊 İstatistiklerim',
        'looking_for': '💕 Kimi Arıyorum',
        'age_range': '🎂 Yaş Aralığı',
        'search_radius': '📍 Arama Yarıçapı'
    },
    'ar': {  # Arabic
        'welcome': 'مرحباً بك في Sarium! 👋\nللاتصالات المجهولة والآمنة',
        'choose_language': 'اختر لغتك:',
        'setup_profile': 'دعنا نقوم بإعداد ملفك الشخصي:\n\n1️⃣ جنسك؟\n2️⃣ عمن تبحث؟\n3️⃣ المدينة/البلد؟\n4️⃣ الموقع التقريبي؟',
        'gender_male': '👨 ذكر',
        'gender_female': '👩 أنثى',
        'gender_other': '🏳️‍🌈 أخرى',
        'looking_for_male': 'أبحث عن ذكر',
        'looking_for_female': 'أبحث عن أنثى',
        'looking_for_any': 'لا يهم',
        'share_location': '📍 مشاركة الموقع',
        'skip_location': '⏭️ تخطي',
        'profile_complete': 'ملفك الشخصي جاهز! ✅\n\n/find للحصول على أول مطابقة',
        'searching_match': '🔍 البحث عن مطابقة مناسبة...',
        'match_found': '🎉 تم العثور على مطابقة!\n\nهل تريد بدء المحادثة؟',
        'start_chat': '💬 بدء المحادثة',
        'next_match': '⏭️ المطابقة التالية',
        'change_filters': '⚙️ تغيير المرشحات',
        'chat_started': '💬 بدأت المحادثة!\n\nللإنهاء: /stop\nللإبلاغ: /report',
        'chat_ended': '👋 انتهت المحادثة.\n\n/find لمطابقة جديدة',
        'report_user': '🚨 الإبلاغ عن المستخدم',
        'block_user': '🚫 حظر المستخدم',
        'end_chat': '❌ إنهاء المحادثة',
        'self_destruct': '💣 التدمير الذاتي',
        'icebreaker': '🧊 كاسر الجليد',
        'profile_menu': '👤 ملفي الشخصي',
        'edit_profile': '✏️ تعديل الملف الشخصي',
        'premium': '⭐ بريميوم',
        'help': '❓ مساعدة',
        'safety_warning': '⚠️ لا تشارك معلوماتك الشخصية أبداً!\n\nاستخدم التدمير الذاتي للأمان الإضافي.',
        'report_reasons': {
            'spam': '📧 رسائل مزعجة',
            'abuse': '😡 سوء معاملة',
            'nsfw': '🔞 محتوى غير مناسب',
            'other': '❓ أخرى'
        },
        
        # Profile & Settings
        'profile': '👤 الملف الشخصي',
        'settings': '⚙️ الإعدادات',
        'edit_profile': '✏️ تعديل الملف الشخصي',
        'search_settings': '⚙️ إعدادات البحث',
        'view_photos': '👁️ عرض الصور',
        'upload_photo': '📸 رفع صورة',
        'back_to_menu': '🔙 العودة للقائمة',
        'back_to_profile': '🔙 العودة للملف الشخصي',
        'edit_name': '👤 تعديل الاسم',
        'edit_age': '🎂 تعديل العمر',
        'edit_country': '🌍 تعديل البلد',
        'edit_city': '🏙️ تعديل المدينة',
        'edit_bio': '✏️ تعديل النبذة',
        'edit_interests': '🎯 تعديل الاهتمامات',
        'edit_gender': '⚧️ تعديل الجنس',
        'language': '🌍 اللغة',
        'change_language': '🌍 تغيير اللغة',
        'invisible_mode': '👻 الوضع المخفي',
        'privacy': '🔒 الخصوصية',
        'delete_account': '🗑️ حذف الحساب',
        'my_stats': '📊 إحصائياتي',
        'looking_for': '💕 أبحث عن',
        'age_range': '🎂 الفئة العمرية',
        'search_radius': '📍 نطاق البحث'
    },
    
    # Add more languages
    'ru': {  # Russian
        'profile': '👤 Профиль',
        'settings': '⚙️ Настройки',
        'edit_profile': '✏️ Редактировать профиль',
        'search_settings': '⚙️ Настройки поиска',
        'view_photos': '👁️ Просмотр фото',
        'upload_photo': '📸 Загрузить фото',
        'back_to_menu': '🔙 Назад в меню',
        'back_to_profile': '🔙 Назад к профилю',
        'edit_name': '👤 Изменить имя',
        'edit_age': '🎂 Изменить возраст',
        'edit_country': '🌍 Изменить страну',
        'edit_city': '🏙️ Изменить город',
        'edit_bio': '✏️ Изменить биографию',
        'edit_interests': '🎯 Изменить интересы',
        'edit_gender': '⚧️ Изменить пол',
        'language': '🌍 Язык',
        'change_language': '🌍 Изменить язык',
        'invisible_mode': '👻 Невидимый режим',
        'privacy': '🔒 Приватность',
        'delete_account': '🗑️ Удалить аккаунт',
        'my_stats': '📊 Моя статистика',
        'looking_for': '💕 Ищу',
        'age_range': '🎂 Возрастной диапазон',
        'search_radius': '📍 Радиус поиска'
    },
    
    'es': {  # Spanish
        'profile': '👤 Perfil',
        'settings': '⚙️ Configuración',
        'edit_profile': '✏️ Editar perfil',
        'search_settings': '⚙️ Configuración de búsqueda',
        'view_photos': '👁️ Ver fotos',
        'upload_photo': '📸 Subir foto',
        'back_to_menu': '🔙 Volver al menú',
        'back_to_profile': '🔙 Volver al perfil',
        'edit_name': '👤 Editar nombre',
        'edit_age': '🎂 Editar edad',
        'edit_country': '🌍 Editar país',
        'edit_city': '🏙️ Editar ciudad',
        'edit_bio': '✏️ Editar biografía',
        'edit_interests': '🎯 Editar intereses',
        'edit_gender': '⚧️ Editar género',
        'language': '🌍 Idioma',
        'change_language': '🌍 Cambiar idioma',
        'invisible_mode': '👻 Modo invisible',
        'privacy': '🔒 Privacidad',
        'delete_account': '🗑️ Eliminar cuenta',
        'my_stats': '📊 Mis estadísticas',
        'looking_for': '💕 Busco',
        'age_range': '🎂 Rango de edad',
        'search_radius': '📍 Radio de búsqueda'
    },
    
    'uk': {  # Ukrainian
        'profile': '👤 Профіль',
        'settings': '⚙️ Налаштування',
        'edit_profile': '✏️ Редагувати профіль',
        'search_settings': '⚙️ Налаштування пошуку',
        'view_photos': '👁️ Переглянути фото',
        'upload_photo': '📸 Завантажити фото',
        'back_to_menu': '🔙 Назад до меню',
        'back_to_profile': '🔙 Назад до профілю',
        'edit_name': '👤 Змінити ім\'я',
        'edit_age': '🎂 Змінити вік',
        'edit_country': '🌍 Змінити країну',
        'edit_city': '🏙️ Змінити місто',
        'edit_bio': '✏️ Змінити біографію',
        'edit_interests': '🎯 Змінити інтереси',
        'edit_gender': '⚧️ Змінити стать',
        'language': '🌍 Мова',
        'change_language': '🌍 Змінити мову',
        'invisible_mode': '👻 Невидимий режим',
        'privacy': '🔒 Приватність',
        'delete_account': '🗑️ Видалити акаунт',
        'my_stats': '📊 Моя статистика',
        'looking_for': '💕 Шукаю',
        'age_range': '🎂 Віковий діапазон',
        'search_radius': '📍 Радіус пошуку'
    },
    
    'hi': {  # Hindi
        'profile': '👤 प्रोफाइल',
        'settings': '⚙️ सेटिंग्स',
        'edit_profile': '✏️ प्रोफाइल संपादित करें',
        'search_settings': '⚙️ खोज सेटिंग्स',
        'view_photos': '👁️ फोटो देखें',
        'upload_photo': '📸 फोटो अपलोड करें',
        'back_to_menu': '🔙 मेनू पर वापस',
        'back_to_profile': '🔙 प्रोफाइल पर वापस',
        'edit_name': '👤 नाम संपादित करें',
        'edit_age': '🎂 उम्र संपादित करें',
        'edit_country': '🌍 देश संपादित करें',
        'edit_city': '🏙️ शहर संपादित करें',
        'edit_bio': '✏️ बायो संपादित करें',
        'edit_interests': '🎯 रुचियां संपादित करें',
        'edit_gender': '⚧️ लिंग संपादित करें',
        'language': '🌍 भाषा',
        'change_language': '🌍 भाषा बदलें',
        'invisible_mode': '👻 अदृश्य मोड',
        'privacy': '🔒 गोपनीयता',
        'delete_account': '🗑️ खाता हटाएं',
        'my_stats': '📊 मेरे आंकड़े',
        'looking_for': '💕 खोज रहा हूं',
        'age_range': '🎂 आयु सीमा',
        'search_radius': '📍 खोज त्रिज्या'
    },
    
    'it': {  # Italian
        'profile': '👤 Profilo',
        'settings': '⚙️ Impostazioni',
        'edit_profile': '✏️ Modifica profilo',
        'search_settings': '⚙️ Impostazioni ricerca',
        'view_photos': '👁️ Visualizza foto',
        'upload_photo': '📸 Carica foto',
        'back_to_menu': '🔙 Torna al menu',
        'back_to_profile': '🔙 Torna al profilo',
        'edit_name': '👤 Modifica nome',
        'edit_age': '🎂 Modifica età',
        'edit_country': '🌍 Modifica paese',
        'edit_city': '🏙️ Modifica città',
        'edit_bio': '✏️ Modifica biografia',
        'edit_interests': '🎯 Modifica interessi',
        'edit_gender': '⚧️ Modifica genere',
        'language': '🌍 Lingua',
        'change_language': '🌍 Cambia lingua',
        'invisible_mode': '👻 Modalità invisibile',
        'privacy': '🔒 Privacy',
        'delete_account': '🗑️ Elimina account',
        'my_stats': '📊 Le mie statistiche',
        'looking_for': '💕 Cerco',
        'age_range': '🎂 Fascia d\'età',
        'search_radius': '📍 Raggio di ricerca'
    },
    
    'fr': {  # French
        'profile': '👤 Profil',
        'settings': '⚙️ Paramètres',
        'edit_profile': '✏️ Modifier le profil',
        'search_settings': '⚙️ Paramètres de recherche',
        'view_photos': '👁️ Voir les photos',
        'upload_photo': '📸 Télécharger une photo',
        'back_to_menu': '🔙 Retour au menu',
        'back_to_profile': '🔙 Retour au profil',
        'edit_name': '👤 Modifier le nom',
        'edit_age': '🎂 Modifier l\'âge',
        'edit_country': '🌍 Modifier le pays',
        'edit_city': '🏙️ Modifier la ville',
        'edit_bio': '✏️ Modifier la bio',
        'edit_interests': '🎯 Modifier les intérêts',
        'edit_gender': '⚧️ Modifier le genre',
        'language': '🌍 Langue',
        'change_language': '🌍 Changer de langue',
        'invisible_mode': '👻 Mode invisible',
        'privacy': '🔒 Confidentialité',
        'delete_account': '🗑️ Supprimer le compte',
        'my_stats': '📊 Mes statistiques',
        'looking_for': '💕 Je cherche',
        'age_range': '🎂 Tranche d\'âge',
        'search_radius': '📍 Rayon de recherche'
    },
    
    'pt': {  # Portuguese
        'profile': '👤 Perfil',
        'settings': '⚙️ Configurações',
        'edit_profile': '✏️ Editar perfil',
        'search_settings': '⚙️ Configurações de busca',
        'view_photos': '👁️ Ver fotos',
        'upload_photo': '📸 Enviar foto',
        'back_to_menu': '🔙 Voltar ao menu',
        'back_to_profile': '🔙 Voltar ao perfil',
        'edit_name': '👤 Editar nome',
        'edit_age': '🎂 Editar idade',
        'edit_country': '🌍 Editar país',
        'edit_city': '🏙️ Editar cidade',
        'edit_bio': '✏️ Editar biografia',
        'edit_interests': '🎯 Editar interesses',
        'edit_gender': '⚧️ Editar gênero',
        'language': '🌍 Idioma',
        'change_language': '🌍 Mudar idioma',
        'invisible_mode': '👻 Modo invisível',
        'privacy': '🔒 Privacidade',
        'delete_account': '🗑️ Excluir conta',
        'my_stats': '📊 Minhas estatísticas',
        'looking_for': '💕 Procuro',
        'age_range': '🎂 Faixa etária',
        'search_radius': '📍 Raio de busca'
    },
    
    'id': {  # Indonesian
        'profile': '👤 Profil',
        'settings': '⚙️ Pengaturan',
        'edit_profile': '✏️ Edit profil',
        'search_settings': '⚙️ Pengaturan pencarian',
        'view_photos': '👁️ Lihat foto',
        'upload_photo': '📸 Unggah foto',
        'back_to_menu': '🔙 Kembali ke menu',
        'back_to_profile': '🔙 Kembali ke profil',
        'edit_name': '👤 Edit nama',
        'edit_age': '🎂 Edit umur',
        'edit_country': '🌍 Edit negara',
        'edit_city': '🏙️ Edit kota',
        'edit_bio': '✏️ Edit bio',
        'edit_interests': '🎯 Edit minat',
        'edit_gender': '⚧️ Edit jenis kelamin',
        'language': '🌍 Bahasa',
        'change_language': '🌍 Ganti bahasa',
        'invisible_mode': '👻 Mode tak terlihat',
        'privacy': '🔒 Privasi',
        'delete_account': '🗑️ Hapus akun',
        'my_stats': '📊 Statistik saya',
        'looking_for': '💕 Mencari',
        'age_range': '🎂 Rentang usia',
        'search_radius': '📍 Radius pencarian'
    },
    
    'kk': {  # Kazakh
        'profile': '👤 Профиль',
        'settings': '⚙️ Баптаулар',
        'edit_profile': '✏️ Профильді өңдеу',
        'search_settings': '⚙️ Іздеу баптаулары',
        'view_photos': '👁️ Фотоларды көру',
        'upload_photo': '📸 Фото жүктеу',
        'back_to_menu': '🔙 Мәзірге оралу',
        'back_to_profile': '🔙 Профильге оралу',
        'edit_name': '👤 Атын өңдеу',
        'edit_age': '🎂 Жасын өңдеу',
        'edit_country': '🌍 Елін өңдеу',
        'edit_city': '🏙️ Қаласын өңдеу',
        'edit_bio': '✏️ Биографияны өңдеу',
        'edit_interests': '🎯 Қызығушылықтарды өңдеу',
        'edit_gender': '⚧️ Жынысын өңдеу',
        'language': '🌍 Тіл',
        'change_language': '🌍 Тілді өзгерту',
        'invisible_mode': '👻 Көрінбейтін режим',
        'privacy': '🔒 Жеке өмір',
        'delete_account': '🗑️ Аккаунтты жою',
        'my_stats': '📊 Менің статистикам',
        'looking_for': '💕 Іздеймін',
        'age_range': '🎂 Жас аралығы',
        'search_radius': '📍 Іздеу радиусы'
    },
    
    'de': {  # German
        'profile': '👤 Profil',
        'settings': '⚙️ Einstellungen',
        'edit_profile': '✏️ Profil bearbeiten',
        'search_settings': '⚙️ Sucheinstellungen',
        'view_photos': '👁️ Fotos anzeigen',
        'upload_photo': '📸 Foto hochladen',
        'back_to_menu': '🔙 Zurück zum Menü',
        'back_to_profile': '🔙 Zurück zum Profil',
        'edit_name': '👤 Name bearbeiten',
        'edit_age': '🎂 Alter bearbeiten',
        'edit_country': '🌍 Land bearbeiten',
        'edit_city': '🏙️ Stadt bearbeiten',
        'edit_bio': '✏️ Bio bearbeiten',
        'edit_interests': '🎯 Interessen bearbeiten',
        'edit_gender': '⚧️ Geschlecht bearbeiten',
        'language': '🌍 Sprache',
        'change_language': '🌍 Sprache ändern',
        'invisible_mode': '👻 Unsichtbarer Modus',
        'privacy': '🔒 Datenschutz',
        'delete_account': '🗑️ Konto löschen',
        'my_stats': '📊 Meine Statistiken',
        'looking_for': '💕 Suche',
        'age_range': '🎂 Altersbereich',
        'search_radius': '📍 Suchradius'
    },
    
    'pl': {  # Polish
        'profile': '👤 Profil',
        'settings': '⚙️ Ustawienia',
        'edit_profile': '✏️ Edytuj profil',
        'search_settings': '⚙️ Ustawienia wyszukiwania',
        'view_photos': '👁️ Zobacz zdjęcia',
        'upload_photo': '📸 Prześlij zdjęcie',
        'back_to_menu': '🔙 Powrót do menu',
        'back_to_profile': '🔙 Powrót do profilu',
        'edit_name': '👤 Edytuj imię',
        'edit_age': '🎂 Edytuj wiek',
        'edit_country': '🌍 Edytuj kraj',
        'edit_city': '🏙️ Edytuj miasto',
        'edit_bio': '✏️ Edytuj bio',
        'edit_interests': '🎯 Edytuj zainteresowania',
        'edit_gender': '⚧️ Edytuj płeć',
        'language': '🌍 Język',
        'change_language': '🌍 Zmień język',
        'invisible_mode': '👻 Tryb niewidoczny',
        'privacy': '🔒 Prywatność',
        'delete_account': '🗑️ Usuń konto',
        'my_stats': '📊 Moje statystyki',
        'looking_for': '💕 Szukam',
        'age_range': '🎂 Przedział wiekowy',
        'search_radius': '📍 Promień wyszukiwania'
    }
}

def get_text(lang: str, key: str, default_lang: str = 'en') -> str:
    """Get translated text with fallback to English"""
    if lang in translations and key in translations[lang]:
        return translations[lang][key]
    elif default_lang in translations and key in translations[default_lang]:
        return translations[default_lang][key]
    else:
        return key  # Return key if no translation found

def get_nested_text(lang: str, category: str, key: str, default_lang: str = 'en') -> str:
    """Get nested translated text (e.g., report_reasons.spam)"""
    if lang in translations and category in translations[lang] and key in translations[lang][category]:
        return translations[lang][category][key]
    elif default_lang in translations and category in translations[default_lang] and key in translations[default_lang][category]:
        return translations[default_lang][category][key]
    else:
        return key
