"""
Translation Helper - سیستم چندزبانه
"""

from .translations import translations, LANGUAGE_CODES

def get_text(lang_code: str, key: str, **kwargs) -> str:
    """
    دریافت متن ترجمه شده
    
    Args:
        lang_code: کد زبان (fa, en, tr, ...)
        key: کلید متن
        **kwargs: متغیرهای قابل جایگزین در متن
    
    Returns:
        متن ترجمه شده
    """
    # اگر زبان موجود نباشد، از فارسی استفاده کن
    if lang_code not in translations:
        lang_code = 'fa'
    
    # اگر کلید موجود نباشد، از فارسی استفاده کن
    if key not in translations[lang_code]:
        lang_code = 'fa'
    
    # اگر هنوز هم موجود نباشد، خود کلید را برگردان
    if key not in translations[lang_code]:
        return key
    
    text = translations[lang_code][key]
    
    # جایگزینی متغیرها
    if kwargs:
        try:
            text = text.format(**kwargs)
        except:
            pass
    
    return text

def get_language_name(lang_code: str) -> str:
    """دریافت نام زبان"""
    return LANGUAGE_CODES.get(lang_code, lang_code)

def get_available_languages() -> dict:
    """دریافت لیست زبان‌های موجود"""
    return LANGUAGE_CODES

def is_language_supported(lang_code: str) -> bool:
    """بررسی پشتیبانی زبان"""
    return lang_code in translations
