"""
Fallback Handler - هندلر عمومی
مدیریت پیام‌های نامعتبر و دستورات ناشناخته
"""

from aiogram import Router, F
from aiogram.types import Message
from localization.language_helper import get_user_with_language
from localization.translator import get_text
import logging

router = Router()
logger = logging.getLogger(__name__)

@router.message()
async def handle_invalid_command(message: Message):
    """مدیریت دستورات و پیام‌های نامعتبر"""
    user, user_language = await get_user_with_language(message.from_user.id)
    
    # اگر کاربر ثبت‌نام نکرده، پیام خاصی نمی‌دهیم
    if not user:
        return
    
    await message.answer(
        f"❓ {get_text(user_language, 'invalid_command', default='دستور نامعتبر است. لطفاً از دکمه‌های منو استفاده کنید.')}"
            )
