"""
Help Handler - هندلر راهنما
راهنمای استفاده از بات
"""

from aiogram import Router, F
from aiogram.types import Message, CallbackQuery, InlineKeyboardMarkup, InlineKeyboardButton, ReplyKeyboardMarkup, KeyboardButton
from localization.language_helper import get_user_with_language
from localization.translator import get_text
import logging

router = Router()
logger = logging.getLogger(__name__)

@router.message(F.text.contains("❓ راهنما") | F.text.contains("❓ Help") | F.text.contains("❓ Yardım") | F.text.contains("❓ مساعدة") | F.text.contains("❓ Помощь") | F.text.contains("❓ सहायता") | F.text.contains("❓ Aiuto") | F.text.contains("❓ Aide") | F.text.contains("❓ Ajuda") | F.text.contains("❓ Bantuan") | F.text.contains("❓ Көмек") | F.text.contains("❓ Hilfe") | F.text.contains("❓ Pomoc"))
async def help_menu(message: Message):
    """نمایش منوی راهنما"""
    user, user_language = await get_user_with_language(message.from_user.id)
    
    text = f"❓ <b>{get_text(user_language, 'help_text', default='راهنمای استفاده از بات')}</b>\n\n"
    text += f"{get_text(user_language, 'welcome_back', default='به راهنمای بات خوش آمدید!')} 🌹\n\n"
    text += f"{get_text(user_language, 'choose_upload_option', default='یک موضوع را انتخاب کنید:')}"
    
    # کیبورد کاستوم برای راهنما
    keyboard = ReplyKeyboardMarkup(
        keyboard=[
            [
                KeyboardButton(text="👤 راهنمای پروفایل"),
                KeyboardButton(text="⚙️ راهنمای تنظیمات")
            ],
            [
                KeyboardButton(text="🔍 راهنمای یافتن مچ"),
                KeyboardButton(text="💬 راهنمای گفتگوها")
            ],
            [
                KeyboardButton(text="❤️ راهنمای لایک‌ها"),
                KeyboardButton(text="⭐ راهنمای پریمیوم")
            ],
            [
                KeyboardButton(text="💡 سوالات متداول"),
                KeyboardButton(text="📞 پشتیبانی")
            ],
            [
                KeyboardButton(text="📢 معرفی به دوستان")
            ],
            [
                KeyboardButton(text="🔙 بازگشت به منو")
            ]
        ],
        resize_keyboard=True,
        one_time_keyboard=False
    )
    
    await message.answer(text, reply_markup=keyboard, parse_mode='HTML')

# Message handlers برای دکمه‌های کیبورد کاستوم
@router.message(F.text == "👤 راهنمای پروفایل")
async def help_profile_message(message: Message):
    """راهنمای پروفایل از طریق message"""
    await help_profile_action(message)

@router.message(F.text == "🔍 راهنمای یافتن مچ")
async def help_matching_message(message: Message):
    """راهنمای یافتن مچ از طریق message"""
    await help_matching_action(message)

@router.message(F.text == "⚙️ راهنمای تنظیمات")
async def help_settings_message(message: Message):
    """راهنمای تنظیمات از طریق message"""
    await help_settings_action(message)

@router.message(F.text == "💬 راهنمای گفتگوها")
async def help_chat_message(message: Message):
    """راهنمای گفتگو از طریق message"""
    await help_chat_action(message)

@router.message(F.text == "❤️ راهنمای لایک‌ها")
async def help_likes_message(message: Message):
    """راهنمای لایک‌ها از طریق message"""
    await help_likes_action(message)

@router.message(F.text == "⭐ راهنمای پریمیوم")
async def help_premium_message(message: Message):
    """راهنمای پریمیوم از طریق message"""
    await help_premium_action(message)

@router.message(F.text == "💡 سوالات متداول")
async def help_faq_message(message: Message):
    """سوالات متداول از طریق message"""
    await help_faq_action(message)

@router.message(F.text == "📞 پشتیبانی")
async def help_support_message(message: Message):
    """پشتیبانی از طریق message"""
    await help_support_action(message)

@router.message(F.text == "📢 معرفی به دوستان")
async def share_bot_message(message: Message):
    """معرفی به دوستان از طریق message"""
    await share_bot_action(message)

@router.message(F.text == "🔙 بازگشت به منو")
async def back_to_main_menu_help(message: Message):
    """بازگشت به منوی اصلی"""
    from handlers.registration import get_main_menu_keyboard
    from localization.language_helper import get_user_with_language
    import os
    
    user, user_language = await get_user_with_language(message.from_user.id)
    
    if not user:
        await message.answer(f"❌ {get_text(user_language, 'must_register_first', default='ابتدا باید ثبت‌نام کنید.')}")
        return
    
    # بررسی ادمین بودن
    ADMIN_USER_IDS = [int(uid) for uid in os.getenv('ADMIN_USER_IDS', '').split(',') if uid]
    is_admin = message.from_user.id in ADMIN_USER_IDS
    
    await message.answer(
        f"🏠 {get_text(user_language, 'back_to_menu', default='بازگشت به منوی اصلی')}",
        reply_markup=get_main_menu_keyboard(user_language, is_admin=is_admin)
    )

# توابع کمکی
async def help_profile_action(message: Message):
    """عملکرد راهنمای پروفایل"""
    text = "👤 <b>راهنمای پروفایل</b>\n\n"
    text += "<b>📝 ویرایش پروفایل:</b>\n"
    text += "• <b>نام:</b> حداکثر 50 کاراکتر\n"
    text += "• <b>سن:</b> 18 تا 80 سال\n"
    text += "• <b>جنسیت:</b> مرد، زن یا غیره\n"
    text += "• <b>کشور و شهر:</b> با الگوریتم هوشمند\n"
    text += "• <b>بیو:</b> حداکثر 200 کاراکتر\n"
    text += "• <b>علایق:</b> حداکثر 6 مورد از 54 علاقه\n"
    text += "• <b>عکس:</b> حداکثر 5 عکس\n\n"
    text += "<b>🎯 نحوه ویرایش:</b>\n"
    text += "1️⃣ از منوی اصلی روی 'پروفایل من' کلیک کنید\n"
    text += "2️⃣ روی 'ویرایش پروفایل' کلیک کنید\n"
    text += "3️⃣ بخش مورد نظر را انتخاب کنید\n"
    text += "4️⃣ اطلاعات جدید را وارد کنید\n"
    text += "5️⃣ تغییرات خودکار ذخیره می‌شود\n\n"
    text += "<b>💡 نکات برای پروفایل بهتر:</b>\n"
    text += "✅ از عکس‌های واضح و جدید استفاده کنید\n"
    text += "✅ بیو خلاقانه و صادقانه بنویسید\n"
    text += "✅ علایق واقعی خود را ذکر کنید\n"
    text += "✅ حداقل 3 عکس آپلود کنید\n"
    text += "❌ از اطلاعات شخصی مثل شماره تلفن خودداری کنید\n\n"
    text += "<b>📸 مدیریت عکس‌ها:</b>\n"
    text += "• آپلود عکس جدید\n"
    text += "• استفاده از عکس پروفایل تلگرام\n"
    text += "• مشاهده و حذف عکس‌های موجود\n"
    text += "• تعیین عکس اصلی پروفایل"
    
    await message.answer(text, parse_mode='HTML')

async def help_settings_action(message: Message):
    """عملکرد راهنمای تنظیمات"""
    text = "⚙️ <b>راهنمای تنظیمات</b>\n\n"
    text += "<b>🔍 تنظیمات جستجو:</b>\n"
    text += "تنظیمات جستجو به شما کمک می‌کند تا کاربران مناسب‌تری پیدا کنید:\n\n"
    text += "• <b>بازه سنی:</b> تعیین حداقل و حداکثر سن (18-99)\n"
    text += "  مثال: 25-35 سال\n\n"
    text += "• <b>شعاع جستجو:</b> فاصله از موقعیت شما (1-500 کیلومتر)\n"
    text += "  مثال: 50 کیلومتر = فقط افراد نزدیک\n\n"
    text += "• <b>ترجیح جنسیت:</b> انتخاب جنسیت مورد نظر\n"
    text += "  گزینه‌ها: مرد، زن، فرقی نمیکند، غیره\n\n"
    text += "<b>🎯 نحوه تنظیم:</b>\n"
    text += "1️⃣ از منوی پروفایل روی 'تنظیمات جستجو' کلیک کنید\n"
    text += "2️⃣ بازه سنی مورد نظر را وارد کنید (مثال: 25-35)\n"
    text += "3️⃣ شعاع جستجو را به کیلومتر وارد کنید\n"
    text += "4️⃣ جنسیت مورد نظر را انتخاب کنید\n"
    text += "5️⃣ تنظیمات شما ذخیره می‌شود\n\n"
    text += "<b>🌍 تغییر زبان:</b>\n"
    text += "• پشتیبانی از 15 زبان مختلف\n"
    text += "• از منوی تنظیمات > تغییر زبان\n"
    text += "• تمام بخش‌های بات فوراً تغییر می‌کند\n\n"
    text += "<b>🗑️ حذف حساب:</b>\n"
    text += "• حذف دائمی تمام اطلاعات شما\n"
    text += "• شامل: پروفایل، عکس‌ها، مچ‌ها، پیام‌ها\n"
    text += "• این عمل غیرقابل بازگشت است\n"
    text += "• قبل از حذف، هشدار کامل نمایش داده می‌شود\n\n"
    text += "<b>⚠️ نکته مهم:</b>\n"
    text += "تنظیمات جستجو فقط بر کاربرانی که در اکتشاف می‌بینید تأثیر می‌گذارد، نه کسانی که شما را می‌بینند."
    
    await message.answer(text, parse_mode='HTML')

async def help_matching_action(message: Message):
    """عملکرد راهنمای یافتن مچ"""
    text = "🔍 <b>راهنمای یافتن مچ (اکتشاف)</b>\n\n"
    text += "<b>🎯 نحوه کار:</b>\n"
    text += "1️⃣ روی دکمه 'اکتشاف' در منوی اصلی کلیک کنید\n"
    text += "2️⃣ پروفایل‌های پیشنهادی را مشاهده کنید\n"
    text += "3️⃣ با دکمه‌های زیر تعامل کنید:\n"
    text += "   • ❤️ لایک - اگر فرد را پسندیدید\n"
    text += "   • ❌ رد کردن - اگر علاقه‌ای ندارید\n"
    text += "   • ⭐ سوپر لایک - علاقه ویژه (پریمیوم)\n"
    text += "4️⃣ اگر طرف مقابل هم شما را لایک کند = <b>مچ!</b> 🎉\n\n"
    text += "<b>💫 الگوریتم هوشمند:</b>\n"
    text += "• بر اساس علایق مشترک\n"
    text += "• فاصله جغرافیایی\n"
    text += "• بازه سنی تنظیم شده\n"
    text += "• ترجیحات جنسیتی\n\n"
    text += "<b>📊 نکات برای مچ بیشتر:</b>\n"
    text += "✅ پروفایل کامل داشته باشید\n"
    text += "✅ حداقل 3 عکس آپلود کنید\n"
    text += "✅ بیو جذاب بنویسید\n"
    text += "✅ علایق واقعی خود را اضافه کنید\n\n"
    text += "<b>🚫 گزارش کاربر:</b>\n"
    text += "اگر محتوای نامناسب دیدید، حتماً گزارش دهید."
    
    await message.answer(text, parse_mode='HTML')

async def help_chat_action(message: Message):
    """عملکرد راهنمای گفتگو"""
    text = "💬 <b>راهنمای گفتگوها</b>\n\n"
    text += "<b>🎯 شروع گفتگو:</b>\n"
    text += "• فقط با مچ‌های خود می‌توانید گفتگو کنید\n"
    text += "• بعد از مچ شدن، می‌توانید پیام بفرستید\n"
    text += "• گفتگوهای شما خصوصی و امن هستند\n\n"
    text += "<b>📱 مشاهده گفتگوها:</b>\n"
    text += "1️⃣ روی دکمه '💬 گفتگوهای من' در منوی اصلی کلیک کنید\n"
    text += "2️⃣ لیست تمام مچ‌های شما نمایش داده می‌شود\n"
    text += "3️⃣ روی نام هر کاربر کلیک کنید\n"
    text += "4️⃣ دکمه 'ارسال پیام' را بزنید تا وارد چت شوید\n\n"
    text += "<b>💌 انواع پیام:</b>\n"
    text += "• <b>متن:</b> پیام‌های متنی معمولی\n"
    text += "• <b>عکس:</b> ارسال تصاویر\n"
    text += "• <b>صدا:</b> پیام‌های صوتی\n"
    text += "• <b>استیکر:</b> استیکرهای تلگرام\n"
    text += "• <b>📹 چت تصویری:</b> ویدیوهای دایره‌ای (فقط در حالت چت تصویری)\n\n"
    text += "<b>🔔 اطلاع‌رسانی:</b>\n"
    text += "• وقتی پیام جدید دریافت می‌کنید، نوتیفیکیشن دریافت می‌کنید\n"
    text += "• پیام‌های خوانده نشده با علامت مشخص می‌شوند\n\n"
    text += "<b>🚫 گزارش و مسدود کردن:</b>\n"
    text += "• <b>گزارش:</b> اگر محتوای نامناسب دیدید، گزارش دهید\n"
    text += "• <b>آنمچ:</b> برای قطع ارتباط و حذف گفتگو\n"
    text += "• <b>بلاک:</b> مسدود کردن کامل کاربر\n\n"
    text += "<b>✅ قوانین گفتگو:</b>\n"
    text += "• احترام متقابل را رعایت کنید\n"
    text += "• صادق و واقعی باشید\n"
    text += "• از زبان مودبانه استفاده کنید\n\n"
    text += "<b>❌ ممنوعیت‌ها:</b>\n"
    text += "• ارسال محتوای نامناسب یا توهین‌آمیز\n"
    text += "• درخواست اطلاعات مالی یا شخصی\n"
    text += "• آزار و اذیت یا تهدید\n"
    text += "• تبلیغات و اسپم\n\n"
    text += "<b>⚠️ هشدار:</b>\n"
    text += "در صورت تخلف از قوانین، حساب شما مسدود خواهد شد."
    
    await message.answer(text, parse_mode='HTML')

async def help_likes_action(message: Message):
    """عملکرد راهنمای لایک‌ها"""
    text = "❤️ <b>راهنمای لایک‌ها</b>\n\n"
    text += "<b>💕 انواع لایک:</b>\n"
    text += "• <b>لایک معمولی (❤️):</b> نشان دادن علاقه به کاربر\n"
    text += "• <b>سوپر لایک (⭐):</b> علاقه ویژه - فقط پریمیوم\n\n"
    text += "<b>🎯 نحوه کار:</b>\n"
    text += "1️⃣ در بخش اکتشاف، روی دکمه ❤️ کلیک کنید\n"
    text += "2️⃣ لایک شما برای آن کاربر ارسال می‌شود\n"
    text += "3️⃣ اگر آن کاربر هم شما را لایک کند = مچ! 🎉\n\n"
    text += "<b>👁️ مشاهده لایک‌ها:</b>\n"
    text += "• <b>کاربران عادی:</b> تعداد لایک‌ها را می‌بینند\n"
    text += "• <b>کاربران پریمیوم:</b> لیست کامل افرادی که لایک کرده‌اند\n\n"
    text += "<b>⭐ سوپر لایک (پریمیوم):</b>\n"
    text += "• کاربر مقابل فوراً متوجه می‌شود\n"
    text += "• شانس مچ شدن بیشتر است\n"
    text += "• نامحدود برای کاربران پریمیوم\n\n"
    text += "<b>📊 آمار لایک‌ها:</b>\n"
    text += "• تعداد لایک‌های دریافتی\n"
    text += "• تعداد لایک‌های ارسالی\n"
    text += "• نرخ مچ شدن\n\n"
    text += "<b>💡 نکات:</b>\n"
    text += "• پروفایل کامل = لایک بیشتر\n"
    text += "• عکس‌های با کیفیت = توجه بیشتر\n"
    text += "• بیو جذاب = علاقه بیشتر"
    
    await message.answer(text, parse_mode='HTML')

async def help_premium_action(message: Message):
    """عملکرد راهنمای پریمیوم"""
    text = "⭐ <b>راهنمای پریمیوم</b>\n\n"
    text += "<b>💎 مزایای اشتراک پریمیوم:</b>\n\n"
    text += "<b>1️⃣ مشاهده لایک‌ها (👁️):</b>\n"
    text += "• ببینید چه کسانی شما را لایک کرده‌اند\n"
    text += "• دسترسی به لیست کامل لایک‌ها\n\n"
    text += "<b>2️⃣ سوپر لایک نامحدود (⭐):</b>\n"
    text += "• بدون محدودیت سوپر لایک بفرستید\n"
    text += "• توجه بیشتری جلب کنید\n\n"
    text += "<b>3️⃣ بوست پروفایل (🚀):</b>\n"
    text += "• پروفایل شما در صدر نمایش داده می‌شود\n"
    text += "• بازدید و لایک بیشتر\n\n"
    text += "<b>4️⃣ فیلترهای پیشرفته (🔍):</b>\n"
    text += "• جستجوی دقیق‌تر\n"
    text += "• فیلتر بر اساس علایق\n\n"
    text += "<b>5️⃣ حالت ناشناس (👻):</b>\n"
    text += "• پروفایل‌ها را بدون دیده شدن مشاهده کنید\n"
    text += "• حریم خصوصی بیشتر\n\n"
    text += "<b>6️⃣ تغییر موقعیت (📍):</b>\n"
    text += "• با کاربران شهرهای دیگر آشنا شوید\n"
    text += "• قبل از سفر، دوستان جدید پیدا کنید\n\n"
    text += "<b>7️⃣ بدون تبلیغات (🚫):</b>\n"
    text += "• تجربه کاربری بهتر\n"
    text += "• بدون وقفه\n\n"
    text += "<b>💳 نحوه خرید:</b>\n"
    text += "1️⃣ روی دکمه 'پریمیوم' در منوی اصلی کلیک کنید\n"
    text += "2️⃣ پلن مورد نظر را انتخاب کنید (ماهانه/سالانه)\n"
    text += "3️⃣ پرداخت را انجام دهید\n"
    text += "4️⃣ اشتراک شما فوراً فعال می‌شود!\n\n"
    text += "<b>🎁 پیشنهاد ویژه:</b>\n"
    text += "اشتراک سالانه = 2 ماه رایگان! 🎉"
    
    await message.answer(text, parse_mode='HTML')

async def help_faq_action(message: Message):
    """عملکرد سوالات متداول"""
    text = "💡 <b>سوالات متداول</b>\n\n"
    text += "<b>س: چگونه عکس آپلود کنم؟</b>\n"
    text += "ج: از بخش پروفایل > آپلود عکس\n\n"
    text += "<b>س: چرا مچ پیدا نمی‌کنم؟</b>\n"
    text += "ج: پروفایل را کامل کنید و عکس آپلود کنید\n\n"
    text += "<b>س: چگونه پریمیوم بخرم؟</b>\n"
    text += "ج: از منوی اصلی > پریمیوم\n\n"
    text += "<b>س: چگونه کسی را گزارش کنم؟</b>\n"
    text += "ج: در پروفایل کاربر > دکمه گزارش\n\n"
    text += "<b>س: آیا اطلاعاتم امن است؟</b>\n"
    text += "ج: بله، ما از رمزنگاری استفاده می‌کنیم"
    
    await message.answer(text, parse_mode='HTML')

async def help_support_action(message: Message):
    """عملکرد پشتیبانی"""
    text = "📞 <b>پشتیبانی و ارتباط با ما</b>\n\n"
    text += "<b>🆘 چه زمانی با پشتیبانی تماس بگیرید؟</b>\n"
    text += "• مشکل فنی در بات\n"
    text += "• سوال درباره پریمیوم\n"
    text += "• گزارش کاربر نامناسب\n"
    text += "• مشکل در پرداخت\n"
    text += "• پیشنهادات و انتقادات\n\n"
    text += "<b>📱 راه‌های ارتباطی:</b>\n"
    text += "📧 <b>ایمیل:</b> support@chatmilos.com\n"
    text += "💬 <b>تلگرام:</b> @ChatMilosSupport\n"
    text += "🌐 <b>وبسایت:</b> https://chatmilos.com\n"
    text += "⏰ <b>ساعات پاسخگویی:</b> 9 صبح تا 9 شب (UTC+3:30)\n\n"
    text += "<b>📝 هنگام تماس، لطفاً اطلاعات زیر را ارائه دهید:</b>\n"
    text += "• شماره کاربری شما (User ID)\n"
    text += "• شرح کامل مشکل\n"
    text += "• اسکرین‌شات (در صورت امکان)\n"
    text += "• زمان وقوع مشکل\n\n"
    text += "<b>⚡ پاسخگویی سریع:</b>\n"
    text += "• مشکلات فوری: حداکثر 2 ساعت\n"
    text += "• سوالات عمومی: حداکثر 24 ساعت\n\n"
    text += "<b>🔗 لینک‌های مفید:</b>\n"
    text += "• راهنمای کامل: /help\n"
    text += "• سوالات متداول: دکمه 'سوالات متداول'\n\n"
    text += "💙 ما همیشه در خدمت شما هستیم!"
    
    await message.answer(text, parse_mode='HTML')

async def share_bot_action(message: Message):
    """عملکرد معرفی به دوستان"""
    text = "📢 <b>معرفی به دوستان</b>\n\n"
    text += "بات ChatMilos را به دوستان خود معرفی کنید!\n\n"
    text += "🎁 <b>با معرفی هر دوست:</b>\n"
    text += "• 7 روز پریمیوم رایگان\n"
    text += "• 5 سوپر لایک رایگان\n\n"
    text += "📱 <b>لینک اختصاصی شما:</b>\n"
    text += f"<code>https://t.me/ChatMilosBot?start=ref_{message.from_user.id}</code>\n\n"
    text += "👆 روی لینک کلیک کنید تا کپی شود\n\n"
    text += "💬 <b>پیام پیشنهادی:</b>\n"
    text += "\"دوست عزیز! بیا ChatMilos رو امتحان کن، عالیه! 🌹\"\n\n"
    text += "🎉 <b>نکته:</b> هر چه بیشتر دوستان خود را دعوت کنید، پاداش بیشتری دریافت می‌کنید!"
    
    await message.answer(text, parse_mode='HTML')

# ==================== پایان فایل ====================
# تمام callback handlerها حذف شدند - فقط کیبورد کاستوم استفاده می‌شود
