#!/usr/bin/env python3
"""Advanced modular matching system for ChatMilos Bot"""

from aiogram import Router, Bot

# Import all routers from modules
from .matching_filters import router as filters_router
from .matching_display import router as display_router
from .matching_actions import router as actions_router

# Create main router
router = Router()

# Include all sub-routers
router.include_router(filters_router)
router.include_router(display_router)
router.include_router(actions_router)

# Matching manager for notifications
matching_manager = None

def set_matching_manager(bot: Bot):
    """Initialize matching manager"""
    global matching_manager
    from .matching_display import MatchingManager
    matching_manager = MatchingManager()

# Export everything needed
__all__ = ['router', 'set_matching_manager', 'matching_manager']
